{smcl}
{* *! version 1.0.0 9aug2014}{...}
{title:Title}

{phang}
{bf:svarih postestimation {hline 2}} Postestimation tools for {help svarih}


{marker description}{...}
{title:Description}

{pstd}
The following postestimation commands are of special interest after {opt svarih}:

{synoptset 15}{...}
{synopt:Command}Description{p_end}
{synoptline}
{synopt:{helpb dsimih}}create and analyze SIRFs and SFEVDs{p_end}
{synopt:{helpb svarih, cmat}}display estimated coefficients in matrix form{p_end}
{synoptline}
{p2colreset}{...}

{pstd}
There is no direct interface to apply VAR postestimation tools to the underlying VAR of {cmd:svarih}.
If you want to do this run the VAR separately using {help var}, then apply the VAR postestimation tools.
See {help vargranger}, {help valmar}, {help varnorm}, {help varsoc}, {help varstable}, and {help varwle}.
Remember that these tools have to be applied in concordance with the assumption of distinct volatility regimes.

{pstd}
Forecasts for {cmd:svarih} are not implemented in {help fcast}-type commands.
Instead, use {cmd:predict} (see below).

{pstd}
The following standard postestimation commands are also available: 

{synoptset 15}{...}
{synopt:Command}Description{p_end}
{synoptline}
{synopt:{helpb estat}}AIC, BIC, VCE, and estimation sample summary{p_end}
{synopt:{helpb estimates}}cataloging estimation results{p_end}
{synopt:{helpb lincom}}point estimates, standard errors, testing, and inference for linear combinations of coefficients{p_end}
{synopt:{helpb lrtest}}likelihood-ratio test{p_end}
{synopt:{helpb nlcom}}point estimates, standard errors, testing, and inference for nonlinear combinations of coefficients{p_end}
{synopt:{helpb svarih postestimation##options_predict:predict}}fitted values, residuals, shocks, historical decompositions{p_end}
{synopt:{helpb test}}Wald tests of simple and composite linear hypotheses{p_end}
{synopt:{helpb testnl}}Wald tests of nonlinear hypotheses{p_end}
{synoptline}
{p2colreset}{...}


{marker syntax_predict}{...}
{marker predict}{...}
{title:Syntax for predict}

{p 8 16 2}
{cmd:predict}
{dtype}
{c -(}{newvar}|{it:stub}{c )-}
{ifin}
[{cmd:,}
{it:statistic}
{c -(}{opt eq:uation(eqno|eqname)} 
{it:llu_suboptions} |
{it:hd_suboptions}{c )-} ]

{synoptset 22 tabbed}{...}
{synopthdr:statistic}
{synoptline}
{synopt:{opt xb}}fitted values; the default{p_end}
{synopt:{opt r:esiduals}}residuals{p_end}
{synopt:{opt s:hocks}}shock series{p_end}
{synopt:{opt hd:ecomp}}historical decompositions{p_end}
{synoptline}
{p2colreset}{...}

{synoptset 22 tabbed}{...}
{synopthdr:llu_suboptions }
{synoptline}
{synopt:{opt notn:ormalized}}generate shocks whose variances in regime 2 correspond to the elements of the L-matrix rather than being 1{p_end}
{synoptline}
{p2colreset}{...}

{synoptset 22 tabbed}{...}
{synopthdr:hd_suboptions }
{synoptline}
{synopt:{opt hds:hock(eqno|eqname)}}equation whose shock is examined{p_end}
{synopt:{opt hdb:eg(t1)}}beginning date of historical decomposition{p_end}
{synopt:{opt hde:nd(tN)}}ending date of historical decomposition{p_end}
{synoptline}
{p2colreset}{...}

{pstd}
{bf:fitted values}, {bf:residuals} and {bf:shocks} are available both in and out of sample; type {cmd:predict ... if e(sample)} if wanted only for the estimation sample.
Predictions for {cmd:svarih bac} and {cmd:svarih llu} are based on GLS-VAR coefficients if option {opt glsiter(#)}, {it:#}>0, was used, and on VAR coefficients otherwise.


{marker options_predict}{...}
{title:Options for predict}

{dlgtab:Main}

{phang}
{opt xb} calculates fitted values.
The default.
Each call to {cmd:predict} generates one fitted values series.

{phang}
{opt residuals} calculates residuals.
Each call to {cmd:predict} generates one residual series.

{pmore}
Note that the fitted values or residuals generated are the ones from the underlying GLS-VAR or VAR regression(s).
Official Stata's {help svar} will not let you create VAR residuals if your {cmd:svar} specification produces an overidentified model.
No such check is performed in {cmd:svarih}.
In the {cmd:svar} case, you can easily generate VAR residuals by running an equivalent {help var} command and then using {cmd:predict} afterwards.
In the {cmd:svarih} case, the generation of correct VAR residuals underlying {cmd:svarih} estimation would be too cumbersome for the user, so {cmd:predict} after {cmd:svarih} will always let you generate residuals.

{phang}
{opt shocks} calculates the implied shock series.
Each call to {cmd:predict} generates one shock series.

{phang}
{opt hdecomp} calculates historical decompositions.
Required complementary options are {opt hdbeg} and {opt hdend}.
Option {opt hdshock} may optionally by supplied.

{pmore}
In contrast to options {opt xb}, {opt residuals} and {opt shocks}, each call to {cmd:predict} generates {it:neqs} variables, where {it:neqs} is the number of equations in the model.
The naming convention for the {it:neqs} new variables is {it:stub+eqname}, where {it:eqname} is the name of a model equation.
The data set may not contain a variable named {it:stub}.

{phang}
{opt equation(eqno|eqname)} is allowed with options {opt residuals} and {opt shocks} only and specifies the equation to which you are referring.

{pmore}
{opt equation()} is filled in with one {it:eqno} or {it:eqname} for options {opt residuals} and {opt shocks}.
{cmd:equation(#1}) would mean that the calculation is to be made for the first equation, {cmd:equation(#2)} would mean the second, and so on.
You could also refer to the equation by its name; thus, {cmd:equation(income)} would refer to the equation named income and {cmd:equation(hours)}, to the equation named hours.

{pmore}
If you do not specify {opt equation()}, the results are the same as if you specified {cmd:equation(#1)}.

{dlgtab:Suboptions for svarih llutkepohl}

{phang}
{opt notn:ormalized} will calculate series L^(0.5)*e_t, not e_t.
For the basic equations of the model, see section {help svarih_llu##modelequations:Model equations} of {cmd:svarih llutkepohl}.

{dlgtab:Suboptions for historical decompositions}

{phang}
{opt hdshock(eqno|eqname)} uses the calculated shock for the equation corresponding to {it:eqno} or {it:eqname} in order to calculate the historical decomposition.
{it:eqno} or {it:eqname} can be specified as in option {opt equation}.
The {it:i}-th variable created contains a counterfactual series for the {it:i}-th endogenous variable between periods {it:hdbeg} and {it:hdend}, assuming that only shocks for the equation corresponding to {it:eqno}/{it:eqname} are present.

{pmore}
If you do not specify option {opt hdshock}, the 'baseline' forecast, i.e. the regular forecast is calculated.
This is identical to forecasts produced by {help fcast compute}.
Usually, what is of interest is the difference between the counterfactual of only one shock and the baseline where no shock occurs.
In order to create such series, two calls to {cmd:predict} and additional variable subtraction statements are necessary.

{phang}
{opt hdbeg(t1)} and {opt hdend(tN)} specify the beginning and ending periods of the historical decomposition.
{it:t1} and {it:tN} can be numeric values that refer to the numeric date encoding of the frequency of the data set.
In addition, they can be date strings conformable with the frequency of the data set.

{pmore}
Like the option {opt dynamic} of {cmd:fcast compute}, option {opt hdbeg} of {cmd:predict} creates series starting in period {it:hdbeg-1}.
In contrast to {cmd:fcast compute}, option {opt hdecomp} does not automatically extend the data set if necessitated by option {opt hdend}.
This can be accommodated easily through a previous {help tsappend} statement.

{pmore}
If exogenous variables are in the model, they should have nonmissing values in the date range {it:t1}-{it:tN}.
If a missing value occurs in a certain period, all calculated values subsequent to that period would be missing too which is why {cmd:predict} generates an error in these cases.

{pmore}
Historical decompositions currently can only be calculated for daily and lower frequencies.

{pstd}
For more information on using {opt predict} after multiple-equation commands, see {manhelp predict R}.
